# 编程知识百科

你好，我是程序员鱼皮，前腾讯全栈开发，全网 200 万粉的 [AI 编程博主](https://space.bilibili.com/12890453)，也是 [AI 导航](https://ai.codefather.cn) 和 [编程导航](https://www.codefather.cn) 等 10+ 自研产品的创造者。

学编程的时候，经常会遇到各种概念和技术，比如 "什么是 RESTful API"、"什么是微服务"、"什么是 Docker"。去搜索引擎查，结果出来一大堆文章，有的讲得太简单，有的又太复杂，看完还是一头雾水。

为了解决这个问题，我在 [编程导航](https://www.codefather.cn) 和 [B 站](https://space.bilibili.com/12890453/lists/6264323) 上做了一个 **编程知识百科** 系列，用动漫的方式来讲解编程知识，通俗易懂，零基础也能看懂。

![](https://pic.yupi.icu/1/1767663460999-837c637c-9f61-4b21-95a2-5e218ad36a58.png)



## 编程知识百科包含什么？

编程知识百科涵盖了编程学习和工作中会遇到的各种概念、技术、工具，内容包括但不限于：

- 编程基础知识：面向对象、数据结构、算法、设计模式
- 项目开发知识：RESTful API、MVC 架构、数据库设计、索引优化
- AI 编程知识：Prompt 工程、RAG、向量数据库、AI 开发框架
- 工具和技术：Git、Docker、Redis、消息队列、微服务

目前已经更新了几十个知识点，而且还在持续更新中。

![](https://pic.yupi.icu/1/image-20260113145432074.png)



## 编程知识百科的特点

用动漫的方式讲解，不是枯燥的文字和代码，而是生动有趣的动漫形式，让学习变得轻松有趣。

- 通俗易懂：用大白话讲解复杂概念，零基础也能看懂。
- 实战导向：不只讲理论，还会告诉你怎么用、什么场景用。
- 持续更新：紧跟技术发展，及时补充新的内容。

![](https://pic.yupi.icu/1/1767663646677-8c6cbd95-9a06-4447-a276-83d3a505e957-20260113145631574.png)



## 如何学习编程知识百科？

你可以通过以下方式学习编程知识百科：


### 方式一、B 站观看视频

推荐到我的 B 站频道观看视频，动漫讲解更生动，理解起来更容易。

B 站地址：https://space.bilibili.com/12890453/lists/6264323

搜索：**程序员鱼皮**

我会定期更新编程知识百科的视频内容，涵盖各种编程概念、技术、工具的讲解。



### 方式二、编程导航网站学习

访问 [编程导航](https://www.codefather.cn)，在网站上可以查看图文版的知识百科内容。

网站地址：https://www.codefather.cn



### 方式三、关注《程序员鱼皮》公众号

欢迎关注鱼皮的微信公众号《程序员鱼皮》，第一时间获取鱼皮的每日分享：

![](https://pic.yupi.icu/1/%E9%B1%BC%E7%9A%AE%E7%9A%84%E5%BE%AE%E4%BF%A1%E5%85%AC%E4%BC%97%E5%8F%B7.png)




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
